/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.item.Item;
import net.minecraft.world.server.ServerWorld;

public class ShareGoldTask<T extends PiglinEntity>
extends Task<T> {
    private Set<Item> allyDesiredItems = ImmutableSet.of();

    public ShareGoldTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT));
    }

    protected boolean shouldExecute(ServerWorld serverWorld, T owner) {
        LivingEntity ally;
        EntityType entityType = owner.func_200600_R();
        boolean isSharingGold = GreedHelper.isSharingGold(owner);
        boolean hasGold = GreedHelper.doesGreedInventoryHaveGold(owner);
        boolean ownerIsAdult = !owner.func_70631_g_();
        boolean hasOpenOffhandSlot = true;
        if (owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).isPresent() && (ally = (LivingEntity)owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).get()) instanceof PiglinEntity && !PiglinTasksHelper.hasOpenOffhandSlot((PiglinEntity)ally)) {
            hasOpenOffhandSlot = false;
        }
        return isSharingGold && hasGold && ownerIsAdult && hasOpenOffhandSlot && BrainUtil.func_220623_a((Brain)owner.func_213375_cj(), (MemoryModuleType)MemoryModuleType.field_220952_m, (EntityType)entityType);
    }

    protected boolean shouldContinueExecuting(ServerWorld serverWorld, T owner, long gameTime) {
        return this.shouldExecute(serverWorld, owner);
    }

    protected void startExecuting(ServerWorld serverWorld, T owner, long gameTime) {
        if (owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).isPresent()) {
            LivingEntity ally = (LivingEntity)owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).get();
            BrainUtil.func_220618_a(owner, (LivingEntity)ally, (float)0.5f);
            this.allyDesiredItems = GreedHelper.getDesiredItems(ally);
        }
    }

    protected void updateTask(ServerWorld serverWorld, T owner, long gameTime) {
        LivingEntity ally;
        if (owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).isPresent() && owner.func_70068_e((Entity)(ally = (LivingEntity)owner.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).get())) <= 5.0) {
            BrainUtil.func_220618_a(owner, (LivingEntity)ally, (float)0.5f);
            ReputationHelper.spreadGossip(owner, ally, gameTime);
            if (!this.allyDesiredItems.isEmpty() && ally instanceof PiglinEntity) {
                GreedHelper.giveAllyDesiredItem(this.allyDesiredItems, owner, (PiglinEntity)ally);
            }
        }
    }

    protected void resetTask(ServerWorld serverWorld, T owner, long gameTime) {
        owner.func_213375_cj().func_218189_b(MemoryModuleType.field_220952_m);
    }
}

